package com.example.tp6_03.xml;


import com.example.tp6_03.dto.CityDTO;
import com.example.tp6_03.dto.WeatherConditionDTO;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

import java.io.IOException;
import java.io.StringReader;


public class XmlHandler {

    public static CityDTO deSerializeXml2CityDTO(String resp) {
        CityDTO data = null;
        WeatherConditionDTO day = null;
        final int WEATHERDATA = 1;
        final int LOCATION = 10;
        final int FORECAST = 20;
        final int TIME = 21;
        int current_parent_tag = 0;


        String text = "";
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            XmlPullParser parser = factory.newPullParser();
            parser.setInput(new StringReader(resp));


            int eventType = parser.getEventType();
            while (eventType != XmlPullParser.END_DOCUMENT) {
                String tagname = parser.getName();
                switch (eventType) {
                    case XmlPullParser.START_TAG:
                        if (tagname.equalsIgnoreCase("weatherdata")) {
                            current_parent_tag = WEATHERDATA;
                            data = new CityDTO();
                            break;
                        }
                        if (tagname.equalsIgnoreCase("location")) {
                            current_parent_tag = LOCATION;
                            break;
                        }
                        if (tagname.equalsIgnoreCase("forecast")) {
                            current_parent_tag = FORECAST;
                            break;
                        }
                        if (current_parent_tag == FORECAST && tagname.equalsIgnoreCase("time")) {
                            current_parent_tag = TIME;
                            day = new WeatherConditionDTO();
                            String date = parser.getAttributeValue(null, "from");
                            day.setDate(date);
                            break;
                        }
                        if (current_parent_tag == TIME && tagname.equalsIgnoreCase("symbol")) {
                            String icon = parser.getAttributeValue(null, "var");
                            day.setIconUrl(icon);
                            break;
                        }
                        if (current_parent_tag == TIME && tagname.equalsIgnoreCase("temperature")) {
                            String max = parser.getAttributeValue(null, "max");
                            String min = parser.getAttributeValue(null, "min");
                            day.setMax((int)Float.parseFloat(max));
                            day.setMin((int)Float.parseFloat(min));
                            break;
                        }

                        break;
                    case XmlPullParser.TEXT:
                        text = parser.getText();
                        break;
                    case XmlPullParser.END_TAG:

                        if (tagname.equalsIgnoreCase("name") && current_parent_tag == LOCATION) {
                            data.setName(text);
                            break;
                        }
                        if (tagname.equalsIgnoreCase("country") && current_parent_tag == LOCATION) {
                            data.appendName(text);
                            break;
                        }
                        if (tagname.equalsIgnoreCase("time")) {
                            current_parent_tag = FORECAST;
                            data.addWeather(day);
                            day = null;
                            break;
                        }
                        if (tagname.equalsIgnoreCase("forecast")) {
                            current_parent_tag = WEATHERDATA;
                            break;
                        }
                        if (tagname.equalsIgnoreCase("location")) {
                            current_parent_tag = WEATHERDATA;
                            break;
                        }
                        break;
                    default:
                        break;
                }
                eventType = parser.next();
            }

        } catch (XmlPullParserException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }



        return data;
    }


}
